using System;
using System.Linq;

class Program
    {
        static void Main()
        {
            var input = Console.ReadLine().Split(' ').Select(int.Parse).ToArray();
            int N = input[0], M = input[1], K = input[2], L = input[3];

            var A = Console.ReadLine().Split(' ').Select(long.Parse).ToArray();
            long[,] matrix = new long[N, M];

            for (int i = 0; i < N; i++)
            {
                for (int j = 0; j < M; j++)
                {
                    matrix[i, j] = A[i * M + j];
                }
            }

            long maxBeauty = CalculateMaxBeauty(matrix, N, M, K, L);

            Console.WriteLine(maxBeauty);
        }

        static long CalculateMaxBeauty(long[,] matrix, int N, int M, int K, int L)
        {
            long maxSum = 0;

            for (int i = 0; i <= N - K; i++)
            {
                for (int j = 0; j <= M - L; j++)
                {
                    long sum = 0;
                    for (int k = 0; k < K; k++)
                    {
                        for (int l = 0; l < L; l++)
                        {
                            sum += matrix[i + k, j + l];
                        }
                    }
                    maxSum = Math.Max(maxSum, sum);
                }
            }

            return maxSum;
        }
    }